package io.github.vigoo.zioaws.servicediscovery.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateServiceResponse(
    service: Option[io.github.vigoo.zioaws.servicediscovery.model.Service] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.CreateServiceResponse = {
    import CreateServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.CreateServiceResponse
      .builder()
      .optionallyWith(service.map(value => value.buildAwsValue()))(_.service)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.CreateServiceResponse.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.CreateServiceResponse
      .wrap(buildAwsValue())
}
object CreateServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.CreateServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.CreateServiceResponse =
      io.github.vigoo.zioaws.servicediscovery.model
        .CreateServiceResponse(serviceValue.map(value => value.editable))
    def serviceValue
        : Option[io.github.vigoo.zioaws.servicediscovery.model.Service.ReadOnly]
    def service: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.Service.ReadOnly
    ] = AwsError.unwrapOptionField("service", serviceValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.CreateServiceResponse
  ) extends io.github.vigoo.zioaws.servicediscovery.model.CreateServiceResponse.ReadOnly {
    override def serviceValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.Service.ReadOnly
    ] = scala
      .Option(impl.service())
      .map(value =>
        io.github.vigoo.zioaws.servicediscovery.model.Service.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.CreateServiceResponse
  ): io.github.vigoo.zioaws.servicediscovery.model.CreateServiceResponse.ReadOnly =
    new Wrapper(impl)
}
