package io.github.vigoo.zioaws.servicediscovery.model
import scala.jdk.CollectionConverters.*
sealed trait CustomHealthStatus {
  def unwrap: software.amazon.awssdk.services.servicediscovery.model.CustomHealthStatus
}
object CustomHealthStatus {
  def wrap(
      value: software.amazon.awssdk.services.servicediscovery.model.CustomHealthStatus
  ): io.github.vigoo.zioaws.servicediscovery.model.CustomHealthStatus =
    value match {
      case software.amazon.awssdk.services.servicediscovery.model.CustomHealthStatus.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.servicediscovery.model.CustomHealthStatus.HEALTHY =>
        val r = HEALTHY
        r
      case software.amazon.awssdk.services.servicediscovery.model.CustomHealthStatus.UNHEALTHY =>
        val r = UNHEALTHY
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.servicediscovery.model.CustomHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.CustomHealthStatus =
      software.amazon.awssdk.services.servicediscovery.model.CustomHealthStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object HEALTHY
      extends io.github.vigoo.zioaws.servicediscovery.model.CustomHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.CustomHealthStatus =
      software.amazon.awssdk.services.servicediscovery.model.CustomHealthStatus.HEALTHY
  }
  case object UNHEALTHY
      extends io.github.vigoo.zioaws.servicediscovery.model.CustomHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.CustomHealthStatus =
      software.amazon.awssdk.services.servicediscovery.model.CustomHealthStatus.UNHEALTHY
  }
}
