package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.ResourceId
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeregisterInstanceRequest(
    serviceId: ResourceId,
    instanceId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.DeregisterInstanceRequest = {
    import DeregisterInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.DeregisterInstanceRequest
      .builder()
      .serviceId(serviceId: java.lang.String)
      .instanceId(instanceId: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.DeregisterInstanceRequest.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.DeregisterInstanceRequest
      .wrap(buildAwsValue())
}
object DeregisterInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.DeregisterInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.DeregisterInstanceRequest =
      io.github.vigoo.zioaws.servicediscovery.model
        .DeregisterInstanceRequest(serviceIdValue, instanceIdValue)
    def serviceIdValue: ResourceId
    def instanceIdValue: ResourceId
    def serviceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(serviceIdValue)
    def instanceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(instanceIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.DeregisterInstanceRequest
  ) extends io.github.vigoo.zioaws.servicediscovery.model.DeregisterInstanceRequest.ReadOnly {
    override def serviceIdValue: ResourceId = impl.serviceId(): ResourceId
    override def instanceIdValue: ResourceId = impl.instanceId(): ResourceId
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.DeregisterInstanceRequest
  ): io.github.vigoo.zioaws.servicediscovery.model.DeregisterInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
