package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.OperationId
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeregisterInstanceResponse(
    operationId: Option[OperationId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.DeregisterInstanceResponse = {
    import DeregisterInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.DeregisterInstanceResponse
      .builder()
      .optionallyWith(operationId.map(value => value: java.lang.String))(
        _.operationId
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.DeregisterInstanceResponse.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.DeregisterInstanceResponse
      .wrap(buildAwsValue())
}
object DeregisterInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.DeregisterInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.DeregisterInstanceResponse =
      io.github.vigoo.zioaws.servicediscovery.model
        .DeregisterInstanceResponse(operationIdValue.map(value => value))
    def operationIdValue: Option[OperationId]
    def operationId: ZIO[Any, AwsError, OperationId] =
      AwsError.unwrapOptionField("operationId", operationIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.DeregisterInstanceResponse
  ) extends io.github.vigoo.zioaws.servicediscovery.model.DeregisterInstanceResponse.ReadOnly {
    override def operationIdValue: Option[OperationId] =
      scala.Option(impl.operationId()).map(value => value: OperationId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.DeregisterInstanceResponse
  ): io.github.vigoo.zioaws.servicediscovery.model.DeregisterInstanceResponse.ReadOnly =
    new Wrapper(impl)
}
