package io.github.vigoo.zioaws.servicediscovery.model
import java.lang.Integer
import io.github.vigoo.zioaws.servicediscovery.model.primitives.{
  AttrKey,
  NamespaceName,
  AttrValue,
  ServiceName,
  DiscoverMaxResults
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DiscoverInstancesRequest(
    namespaceName: NamespaceName,
    serviceName: ServiceName,
    maxResults: Option[DiscoverMaxResults] = None,
    queryParameters: Option[Map[AttrKey, AttrValue]] = None,
    optionalParameters: Option[Map[AttrKey, AttrValue]] = None,
    healthStatus: Option[
      io.github.vigoo.zioaws.servicediscovery.model.HealthStatusFilter
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.DiscoverInstancesRequest = {
    import DiscoverInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.DiscoverInstancesRequest
      .builder()
      .namespaceName(namespaceName: java.lang.String)
      .serviceName(serviceName: java.lang.String)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(
        queryParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.queryParameters)
      .optionallyWith(
        optionalParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.optionalParameters)
      .optionallyWith(healthStatus.map(value => value.unwrap))(_.healthStatus)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.DiscoverInstancesRequest.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.DiscoverInstancesRequest
      .wrap(buildAwsValue())
}
object DiscoverInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.DiscoverInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.DiscoverInstancesRequest =
      io.github.vigoo.zioaws.servicediscovery.model.DiscoverInstancesRequest(
        namespaceNameValue,
        serviceNameValue,
        maxResultsValue.map(value => value),
        queryParametersValue.map(value => value),
        optionalParametersValue.map(value => value),
        healthStatusValue.map(value => value)
      )
    def namespaceNameValue: NamespaceName
    def serviceNameValue: ServiceName
    def maxResultsValue: Option[DiscoverMaxResults]
    def queryParametersValue: Option[Map[AttrKey, AttrValue]]
    def optionalParametersValue: Option[Map[AttrKey, AttrValue]]
    def healthStatusValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.HealthStatusFilter
    ]
    def namespaceName: ZIO[Any, Nothing, NamespaceName] =
      ZIO.succeed(namespaceNameValue)
    def serviceName: ZIO[Any, Nothing, ServiceName] =
      ZIO.succeed(serviceNameValue)
    def maxResults: ZIO[Any, AwsError, DiscoverMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def queryParameters: ZIO[Any, AwsError, Map[AttrKey, AttrValue]] =
      AwsError.unwrapOptionField("queryParameters", queryParametersValue)
    def optionalParameters: ZIO[Any, AwsError, Map[AttrKey, AttrValue]] =
      AwsError.unwrapOptionField("optionalParameters", optionalParametersValue)
    def healthStatus: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.HealthStatusFilter
    ] = AwsError.unwrapOptionField("healthStatus", healthStatusValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.DiscoverInstancesRequest
  ) extends io.github.vigoo.zioaws.servicediscovery.model.DiscoverInstancesRequest.ReadOnly {
    override def namespaceNameValue: NamespaceName =
      impl.namespaceName(): NamespaceName
    override def serviceNameValue: ServiceName = impl.serviceName(): ServiceName
    override def maxResultsValue: Option[DiscoverMaxResults] =
      scala.Option(impl.maxResults()).map(value => value: DiscoverMaxResults)
    override def queryParametersValue: Option[Map[AttrKey, AttrValue]] = scala
      .Option(impl.queryParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: AttrKey) -> (value: AttrValue)
          })
          .toMap
      )
    override def optionalParametersValue: Option[Map[AttrKey, AttrValue]] =
      scala
        .Option(impl.optionalParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: AttrKey) -> (value: AttrValue)
            })
            .toMap
        )
    override def healthStatusValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.HealthStatusFilter
    ] = scala
      .Option(impl.healthStatus())
      .map(value =>
        io.github.vigoo.zioaws.servicediscovery.model.HealthStatusFilter
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.DiscoverInstancesRequest
  ): io.github.vigoo.zioaws.servicediscovery.model.DiscoverInstancesRequest.ReadOnly =
    new Wrapper(impl)
}
