package io.github.vigoo.zioaws.servicediscovery.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DiscoverInstancesResponse(
    instances: Option[Iterable[
      io.github.vigoo.zioaws.servicediscovery.model.HttpInstanceSummary
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.DiscoverInstancesResponse = {
    import DiscoverInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.DiscoverInstancesResponse
      .builder()
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.DiscoverInstancesResponse.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.DiscoverInstancesResponse
      .wrap(buildAwsValue())
}
object DiscoverInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.DiscoverInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.DiscoverInstancesResponse =
      io.github.vigoo.zioaws.servicediscovery.model.DiscoverInstancesResponse(
        instancesValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def instancesValue: Option[List[
      io.github.vigoo.zioaws.servicediscovery.model.HttpInstanceSummary.ReadOnly
    ]]
    def instances: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.servicediscovery.model.HttpInstanceSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("instances", instancesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.DiscoverInstancesResponse
  ) extends io.github.vigoo.zioaws.servicediscovery.model.DiscoverInstancesResponse.ReadOnly {
    override def instancesValue: Option[List[
      io.github.vigoo.zioaws.servicediscovery.model.HttpInstanceSummary.ReadOnly
    ]] = scala
      .Option(impl.instances())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.servicediscovery.model.HttpInstanceSummary
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.DiscoverInstancesResponse
  ): io.github.vigoo.zioaws.servicediscovery.model.DiscoverInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
