package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.ResourceId
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DnsConfig(
    namespaceId: Option[ResourceId] = None,
    routingPolicy: Option[
      io.github.vigoo.zioaws.servicediscovery.model.RoutingPolicy
    ] = None,
    dnsRecords: Iterable[
      io.github.vigoo.zioaws.servicediscovery.model.DnsRecord
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.DnsConfig = {
    import DnsConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.DnsConfig
      .builder()
      .optionallyWith(namespaceId.map(value => value: java.lang.String))(
        _.namespaceId
      )
      .optionallyWith(routingPolicy.map(value => value.unwrap))(_.routingPolicy)
      .dnsRecords(dnsRecords.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.DnsConfig.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.DnsConfig
      .wrap(buildAwsValue())
}
object DnsConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.DnsConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.servicediscovery.model.DnsConfig =
      io.github.vigoo.zioaws.servicediscovery.model.DnsConfig(
        namespaceIdValue.map(value => value),
        routingPolicyValue.map(value => value),
        dnsRecordsValue.map { item =>
          item.editable
        }
      )
    def namespaceIdValue: Option[ResourceId]
    def routingPolicyValue
        : Option[io.github.vigoo.zioaws.servicediscovery.model.RoutingPolicy]
    def dnsRecordsValue
        : List[io.github.vigoo.zioaws.servicediscovery.model.DnsRecord.ReadOnly]
    def namespaceId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("namespaceId", namespaceIdValue)
    def routingPolicy: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.RoutingPolicy
    ] = AwsError.unwrapOptionField("routingPolicy", routingPolicyValue)
    def dnsRecords: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.servicediscovery.model.DnsRecord.ReadOnly
    ]] = ZIO.succeed(dnsRecordsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.DnsConfig
  ) extends io.github.vigoo.zioaws.servicediscovery.model.DnsConfig.ReadOnly {
    override def namespaceIdValue: Option[ResourceId] =
      scala.Option(impl.namespaceId()).map(value => value: ResourceId)
    override def routingPolicyValue
        : Option[io.github.vigoo.zioaws.servicediscovery.model.RoutingPolicy] =
      scala
        .Option(impl.routingPolicy())
        .map(value =>
          io.github.vigoo.zioaws.servicediscovery.model.RoutingPolicy
            .wrap(value)
        )
    override def dnsRecordsValue: List[
      io.github.vigoo.zioaws.servicediscovery.model.DnsRecord.ReadOnly
    ] = impl
      .dnsRecords()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.servicediscovery.model.DnsRecord.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.DnsConfig
  ): io.github.vigoo.zioaws.servicediscovery.model.DnsConfig.ReadOnly =
    new Wrapper(impl)
}
