package io.github.vigoo.zioaws.servicediscovery.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DnsConfigChange(
    dnsRecords: Iterable[
      io.github.vigoo.zioaws.servicediscovery.model.DnsRecord
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.DnsConfigChange = {
    import DnsConfigChange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.DnsConfigChange
      .builder()
      .dnsRecords(dnsRecords.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.DnsConfigChange.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.DnsConfigChange
      .wrap(buildAwsValue())
}
object DnsConfigChange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.DnsConfigChange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.DnsConfigChange =
      io.github.vigoo.zioaws.servicediscovery.model
        .DnsConfigChange(dnsRecordsValue.map { item =>
          item.editable
        })
    def dnsRecordsValue
        : List[io.github.vigoo.zioaws.servicediscovery.model.DnsRecord.ReadOnly]
    def dnsRecords: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.servicediscovery.model.DnsRecord.ReadOnly
    ]] = ZIO.succeed(dnsRecordsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.DnsConfigChange
  ) extends io.github.vigoo.zioaws.servicediscovery.model.DnsConfigChange.ReadOnly {
    override def dnsRecordsValue: List[
      io.github.vigoo.zioaws.servicediscovery.model.DnsRecord.ReadOnly
    ] = impl
      .dnsRecords()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.servicediscovery.model.DnsRecord.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.DnsConfigChange
  ): io.github.vigoo.zioaws.servicediscovery.model.DnsConfigChange.ReadOnly =
    new Wrapper(impl)
}
