package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.ResourceId
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DnsProperties(
    hostedZoneId: Option[ResourceId] = None,
    soa: Option[io.github.vigoo.zioaws.servicediscovery.model.SOA] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.DnsProperties = {
    import DnsProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.DnsProperties
      .builder()
      .optionallyWith(hostedZoneId.map(value => value: java.lang.String))(
        _.hostedZoneId
      )
      .optionallyWith(soa.map(value => value.buildAwsValue()))(_.soa)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.DnsProperties.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.DnsProperties
      .wrap(buildAwsValue())
}
object DnsProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.DnsProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.servicediscovery.model.DnsProperties =
      io.github.vigoo.zioaws.servicediscovery.model.DnsProperties(
        hostedZoneIdValue.map(value => value),
        soaValue.map(value => value.editable)
      )
    def hostedZoneIdValue: Option[ResourceId]
    def soaValue
        : Option[io.github.vigoo.zioaws.servicediscovery.model.SOA.ReadOnly]
    def hostedZoneId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("hostedZoneId", hostedZoneIdValue)
    def soa: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.SOA.ReadOnly
    ] = AwsError.unwrapOptionField("soa", soaValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.DnsProperties
  ) extends io.github.vigoo.zioaws.servicediscovery.model.DnsProperties.ReadOnly {
    override def hostedZoneIdValue: Option[ResourceId] =
      scala.Option(impl.hostedZoneId()).map(value => value: ResourceId)
    override def soaValue
        : Option[io.github.vigoo.zioaws.servicediscovery.model.SOA.ReadOnly] =
      scala
        .Option(impl.soa())
        .map(value =>
          io.github.vigoo.zioaws.servicediscovery.model.SOA.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.DnsProperties
  ): io.github.vigoo.zioaws.servicediscovery.model.DnsProperties.ReadOnly =
    new Wrapper(impl)
}
