package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.RecordTTL
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DnsRecord(
    `type`: io.github.vigoo.zioaws.servicediscovery.model.RecordType,
    ttl: RecordTTL
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.DnsRecord = {
    import DnsRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.DnsRecord
      .builder()
      .`type`(`type`.unwrap)
      .ttl(ttl: java.lang.Long)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.DnsRecord.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.DnsRecord
      .wrap(buildAwsValue())
}
object DnsRecord {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.DnsRecord
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.servicediscovery.model.DnsRecord =
      io.github.vigoo.zioaws.servicediscovery.model
        .DnsRecord(typeValue, ttlValue)
    def typeValue: io.github.vigoo.zioaws.servicediscovery.model.RecordType
    def ttlValue: RecordTTL
    def `type`: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.servicediscovery.model.RecordType
    ] = ZIO.succeed(typeValue)
    def ttl: ZIO[Any, Nothing, RecordTTL] = ZIO.succeed(ttlValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.DnsRecord
  ) extends io.github.vigoo.zioaws.servicediscovery.model.DnsRecord.ReadOnly {
    override def typeValue
        : io.github.vigoo.zioaws.servicediscovery.model.RecordType =
      io.github.vigoo.zioaws.servicediscovery.model.RecordType
        .wrap(impl.`type`())
    override def ttlValue: RecordTTL = impl.ttl(): RecordTTL
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.DnsRecord
  ): io.github.vigoo.zioaws.servicediscovery.model.DnsRecord.ReadOnly =
    new Wrapper(impl)
}
