package io.github.vigoo.zioaws.servicediscovery.model
import scala.jdk.CollectionConverters.*
sealed trait FilterCondition {
  def unwrap
      : software.amazon.awssdk.services.servicediscovery.model.FilterCondition
}
object FilterCondition {
  def wrap(
      value: software.amazon.awssdk.services.servicediscovery.model.FilterCondition
  ): io.github.vigoo.zioaws.servicediscovery.model.FilterCondition =
    value match {
      case software.amazon.awssdk.services.servicediscovery.model.FilterCondition.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.servicediscovery.model.FilterCondition.EQ =>
        val r = EQ
        r
      case software.amazon.awssdk.services.servicediscovery.model.FilterCondition.IN =>
        val r = IN
        r
      case software.amazon.awssdk.services.servicediscovery.model.FilterCondition.BETWEEN =>
        val r = BETWEEN
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.servicediscovery.model.FilterCondition {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.FilterCondition =
      software.amazon.awssdk.services.servicediscovery.model.FilterCondition.UNKNOWN_TO_SDK_VERSION
  }
  case object EQ
      extends io.github.vigoo.zioaws.servicediscovery.model.FilterCondition {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.FilterCondition =
      software.amazon.awssdk.services.servicediscovery.model.FilterCondition.EQ
  }
  case object IN
      extends io.github.vigoo.zioaws.servicediscovery.model.FilterCondition {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.FilterCondition =
      software.amazon.awssdk.services.servicediscovery.model.FilterCondition.IN
  }
  case object BETWEEN
      extends io.github.vigoo.zioaws.servicediscovery.model.FilterCondition {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.FilterCondition =
      software.amazon.awssdk.services.servicediscovery.model.FilterCondition.BETWEEN
  }
}
