package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.ResourceId
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetInstanceRequest(
    serviceId: ResourceId,
    instanceId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.GetInstanceRequest = {
    import GetInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.GetInstanceRequest
      .builder()
      .serviceId(serviceId: java.lang.String)
      .instanceId(instanceId: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.GetInstanceRequest.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.GetInstanceRequest
      .wrap(buildAwsValue())
}
object GetInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.GetInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.GetInstanceRequest =
      io.github.vigoo.zioaws.servicediscovery.model
        .GetInstanceRequest(serviceIdValue, instanceIdValue)
    def serviceIdValue: ResourceId
    def instanceIdValue: ResourceId
    def serviceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(serviceIdValue)
    def instanceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(instanceIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.GetInstanceRequest
  ) extends io.github.vigoo.zioaws.servicediscovery.model.GetInstanceRequest.ReadOnly {
    override def serviceIdValue: ResourceId = impl.serviceId(): ResourceId
    override def instanceIdValue: ResourceId = impl.instanceId(): ResourceId
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.GetInstanceRequest
  ): io.github.vigoo.zioaws.servicediscovery.model.GetInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
