package io.github.vigoo.zioaws.servicediscovery.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetInstanceResponse(
    instance: Option[io.github.vigoo.zioaws.servicediscovery.model.Instance] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.GetInstanceResponse = {
    import GetInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.GetInstanceResponse
      .builder()
      .optionallyWith(instance.map(value => value.buildAwsValue()))(_.instance)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.GetInstanceResponse.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.GetInstanceResponse
      .wrap(buildAwsValue())
}
object GetInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.GetInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.GetInstanceResponse =
      io.github.vigoo.zioaws.servicediscovery.model
        .GetInstanceResponse(instanceValue.map(value => value.editable))
    def instanceValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.Instance.ReadOnly
    ]
    def instance: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.Instance.ReadOnly
    ] = AwsError.unwrapOptionField("instance", instanceValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.GetInstanceResponse
  ) extends io.github.vigoo.zioaws.servicediscovery.model.GetInstanceResponse.ReadOnly {
    override def instanceValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.Instance.ReadOnly
    ] = scala
      .Option(impl.instance())
      .map(value =>
        io.github.vigoo.zioaws.servicediscovery.model.Instance.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.GetInstanceResponse
  ): io.github.vigoo.zioaws.servicediscovery.model.GetInstanceResponse.ReadOnly =
    new Wrapper(impl)
}
