package io.github.vigoo.zioaws.servicediscovery.model
import java.lang.Integer
import io.github.vigoo.zioaws.servicediscovery.model.primitives.{
  NextToken,
  MaxResults,
  ResourceId
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetInstancesHealthStatusRequest(
    serviceId: ResourceId,
    instances: Option[Iterable[ResourceId]] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusRequest = {
    import GetInstancesHealthStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusRequest
      .builder()
      .serviceId(serviceId: java.lang.String)
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.instances)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.GetInstancesHealthStatusRequest.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.GetInstancesHealthStatusRequest
      .wrap(buildAwsValue())
}
object GetInstancesHealthStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.GetInstancesHealthStatusRequest =
      io.github.vigoo.zioaws.servicediscovery.model
        .GetInstancesHealthStatusRequest(
          serviceIdValue,
          instancesValue.map(value => value),
          maxResultsValue.map(value => value),
          nextTokenValue.map(value => value)
        )
    def serviceIdValue: ResourceId
    def instancesValue: Option[List[ResourceId]]
    def maxResultsValue: Option[MaxResults]
    def nextTokenValue: Option[NextToken]
    def serviceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(serviceIdValue)
    def instances: ZIO[Any, AwsError, List[ResourceId]] =
      AwsError.unwrapOptionField("instances", instancesValue)
    def maxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusRequest
  ) extends io.github.vigoo.zioaws.servicediscovery.model.GetInstancesHealthStatusRequest.ReadOnly {
    override def serviceIdValue: ResourceId = impl.serviceId(): ResourceId
    override def instancesValue: Option[List[ResourceId]] = scala
      .Option(impl.instances())
      .map(value =>
        value.asScala.map { item =>
          item: ResourceId
        }.toList
      )
    override def maxResultsValue: Option[MaxResults] =
      scala.Option(impl.maxResults()).map(value => value: MaxResults)
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusRequest
  ): io.github.vigoo.zioaws.servicediscovery.model.GetInstancesHealthStatusRequest.ReadOnly =
    new Wrapper(impl)
}
