package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.{
  NextToken,
  ResourceId
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetInstancesHealthStatusResponse(
    status: Option[Map[
      ResourceId,
      io.github.vigoo.zioaws.servicediscovery.model.HealthStatus
    ]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusResponse = {
    import GetInstancesHealthStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusResponse
      .builder()
      .optionallyWith(
        status.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.unwrap.toString
            })
            .asJava
        )
      )(_.statusWithStrings)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.GetInstancesHealthStatusResponse.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.GetInstancesHealthStatusResponse
      .wrap(buildAwsValue())
}
object GetInstancesHealthStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.GetInstancesHealthStatusResponse =
      io.github.vigoo.zioaws.servicediscovery.model
        .GetInstancesHealthStatusResponse(
          statusValue.map(value => value),
          nextTokenValue.map(value => value)
        )
    def statusValue: Option[Map[
      ResourceId,
      io.github.vigoo.zioaws.servicediscovery.model.HealthStatus
    ]]
    def nextTokenValue: Option[NextToken]
    def status: ZIO[Any, AwsError, Map[
      ResourceId,
      io.github.vigoo.zioaws.servicediscovery.model.HealthStatus
    ]] = AwsError.unwrapOptionField("status", statusValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusResponse
  ) extends io.github.vigoo.zioaws.servicediscovery.model.GetInstancesHealthStatusResponse.ReadOnly {
    override def statusValue: Option[Map[
      ResourceId,
      io.github.vigoo.zioaws.servicediscovery.model.HealthStatus
    ]] = scala
      .Option(impl.status())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: ResourceId) -> io.github.vigoo.zioaws.servicediscovery.model.HealthStatus
              .wrap(value)
          })
          .toMap
      )
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusResponse
  ): io.github.vigoo.zioaws.servicediscovery.model.GetInstancesHealthStatusResponse.ReadOnly =
    new Wrapper(impl)
}
