package io.github.vigoo.zioaws.servicediscovery.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetNamespaceResponse(
    namespace: Option[io.github.vigoo.zioaws.servicediscovery.model.Namespace] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.GetNamespaceResponse = {
    import GetNamespaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.GetNamespaceResponse
      .builder()
      .optionallyWith(namespace.map(value => value.buildAwsValue()))(
        _.namespace
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.GetNamespaceResponse.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.GetNamespaceResponse
      .wrap(buildAwsValue())
}
object GetNamespaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.GetNamespaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.GetNamespaceResponse =
      io.github.vigoo.zioaws.servicediscovery.model
        .GetNamespaceResponse(namespaceValue.map(value => value.editable))
    def namespaceValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.Namespace.ReadOnly
    ]
    def namespace: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.Namespace.ReadOnly
    ] = AwsError.unwrapOptionField("namespace", namespaceValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.GetNamespaceResponse
  ) extends io.github.vigoo.zioaws.servicediscovery.model.GetNamespaceResponse.ReadOnly {
    override def namespaceValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.Namespace.ReadOnly
    ] = scala
      .Option(impl.namespace())
      .map(value =>
        io.github.vigoo.zioaws.servicediscovery.model.Namespace.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.GetNamespaceResponse
  ): io.github.vigoo.zioaws.servicediscovery.model.GetNamespaceResponse.ReadOnly =
    new Wrapper(impl)
}
