package io.github.vigoo.zioaws.servicediscovery.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetOperationResponse(
    operation: Option[io.github.vigoo.zioaws.servicediscovery.model.Operation] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.GetOperationResponse = {
    import GetOperationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.GetOperationResponse
      .builder()
      .optionallyWith(operation.map(value => value.buildAwsValue()))(
        _.operation
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.GetOperationResponse.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.GetOperationResponse
      .wrap(buildAwsValue())
}
object GetOperationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.GetOperationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.GetOperationResponse =
      io.github.vigoo.zioaws.servicediscovery.model
        .GetOperationResponse(operationValue.map(value => value.editable))
    def operationValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.Operation.ReadOnly
    ]
    def operation: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.Operation.ReadOnly
    ] = AwsError.unwrapOptionField("operation", operationValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.GetOperationResponse
  ) extends io.github.vigoo.zioaws.servicediscovery.model.GetOperationResponse.ReadOnly {
    override def operationValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.Operation.ReadOnly
    ] = scala
      .Option(impl.operation())
      .map(value =>
        io.github.vigoo.zioaws.servicediscovery.model.Operation.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.GetOperationResponse
  ): io.github.vigoo.zioaws.servicediscovery.model.GetOperationResponse.ReadOnly =
    new Wrapper(impl)
}
