package io.github.vigoo.zioaws.servicediscovery.model
import java.lang.Integer
import io.github.vigoo.zioaws.servicediscovery.model.primitives.{
  FailureThreshold,
  ResourcePath
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class HealthCheckConfig(
    `type`: io.github.vigoo.zioaws.servicediscovery.model.HealthCheckType,
    resourcePath: Option[ResourcePath] = None,
    failureThreshold: Option[FailureThreshold] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.HealthCheckConfig = {
    import HealthCheckConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.HealthCheckConfig
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(resourcePath.map(value => value: java.lang.String))(
        _.resourcePath
      )
      .optionallyWith(failureThreshold.map(value => value: Integer))(
        _.failureThreshold
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.HealthCheckConfig.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.HealthCheckConfig
      .wrap(buildAwsValue())
}
object HealthCheckConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.HealthCheckConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.HealthCheckConfig =
      io.github.vigoo.zioaws.servicediscovery.model.HealthCheckConfig(
        typeValue,
        resourcePathValue.map(value => value),
        failureThresholdValue.map(value => value)
      )
    def typeValue: io.github.vigoo.zioaws.servicediscovery.model.HealthCheckType
    def resourcePathValue: Option[ResourcePath]
    def failureThresholdValue: Option[FailureThreshold]
    def `type`: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.servicediscovery.model.HealthCheckType
    ] = ZIO.succeed(typeValue)
    def resourcePath: ZIO[Any, AwsError, ResourcePath] =
      AwsError.unwrapOptionField("resourcePath", resourcePathValue)
    def failureThreshold: ZIO[Any, AwsError, FailureThreshold] =
      AwsError.unwrapOptionField("failureThreshold", failureThresholdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.HealthCheckConfig
  ) extends io.github.vigoo.zioaws.servicediscovery.model.HealthCheckConfig.ReadOnly {
    override def typeValue
        : io.github.vigoo.zioaws.servicediscovery.model.HealthCheckType =
      io.github.vigoo.zioaws.servicediscovery.model.HealthCheckType
        .wrap(impl.`type`())
    override def resourcePathValue: Option[ResourcePath] =
      scala.Option(impl.resourcePath()).map(value => value: ResourcePath)
    override def failureThresholdValue: Option[FailureThreshold] = scala
      .Option(impl.failureThreshold())
      .map(value => value: FailureThreshold)
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.HealthCheckConfig
  ): io.github.vigoo.zioaws.servicediscovery.model.HealthCheckConfig.ReadOnly =
    new Wrapper(impl)
}
