package io.github.vigoo.zioaws.servicediscovery.model
import java.lang.Integer
import io.github.vigoo.zioaws.servicediscovery.model.primitives.FailureThreshold
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class HealthCheckCustomConfig(
    failureThreshold: Option[FailureThreshold] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.HealthCheckCustomConfig = {
    import HealthCheckCustomConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.HealthCheckCustomConfig
      .builder()
      .optionallyWith(failureThreshold.map(value => value: Integer))(
        _.failureThreshold
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.HealthCheckCustomConfig.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.HealthCheckCustomConfig
      .wrap(buildAwsValue())
}
object HealthCheckCustomConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.HealthCheckCustomConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.HealthCheckCustomConfig =
      io.github.vigoo.zioaws.servicediscovery.model
        .HealthCheckCustomConfig(failureThresholdValue.map(value => value))
    def failureThresholdValue: Option[FailureThreshold]
    def failureThreshold: ZIO[Any, AwsError, FailureThreshold] =
      AwsError.unwrapOptionField("failureThreshold", failureThresholdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.HealthCheckCustomConfig
  ) extends io.github.vigoo.zioaws.servicediscovery.model.HealthCheckCustomConfig.ReadOnly {
    override def failureThresholdValue: Option[FailureThreshold] = scala
      .Option(impl.failureThreshold())
      .map(value => value: FailureThreshold)
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.HealthCheckCustomConfig
  ): io.github.vigoo.zioaws.servicediscovery.model.HealthCheckCustomConfig.ReadOnly =
    new Wrapper(impl)
}
