package io.github.vigoo.zioaws.servicediscovery.model
import scala.jdk.CollectionConverters.*
sealed trait HealthCheckType {
  def unwrap
      : software.amazon.awssdk.services.servicediscovery.model.HealthCheckType
}
object HealthCheckType {
  def wrap(
      value: software.amazon.awssdk.services.servicediscovery.model.HealthCheckType
  ): io.github.vigoo.zioaws.servicediscovery.model.HealthCheckType =
    value match {
      case software.amazon.awssdk.services.servicediscovery.model.HealthCheckType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.servicediscovery.model.HealthCheckType.HTTP =>
        val r = HTTP
        r
      case software.amazon.awssdk.services.servicediscovery.model.HealthCheckType.HTTPS =>
        val r = HTTPS
        r
      case software.amazon.awssdk.services.servicediscovery.model.HealthCheckType.TCP =>
        val r = TCP
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.servicediscovery.model.HealthCheckType {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.HealthCheckType =
      software.amazon.awssdk.services.servicediscovery.model.HealthCheckType.UNKNOWN_TO_SDK_VERSION
  }
  case object HTTP
      extends io.github.vigoo.zioaws.servicediscovery.model.HealthCheckType {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.HealthCheckType =
      software.amazon.awssdk.services.servicediscovery.model.HealthCheckType.HTTP
  }
  case object HTTPS
      extends io.github.vigoo.zioaws.servicediscovery.model.HealthCheckType {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.HealthCheckType =
      software.amazon.awssdk.services.servicediscovery.model.HealthCheckType.HTTPS
  }
  case object TCP
      extends io.github.vigoo.zioaws.servicediscovery.model.HealthCheckType {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.HealthCheckType =
      software.amazon.awssdk.services.servicediscovery.model.HealthCheckType.TCP
  }
}
