package io.github.vigoo.zioaws.servicediscovery.model
import scala.jdk.CollectionConverters.*
sealed trait HealthStatus {
  def unwrap
      : software.amazon.awssdk.services.servicediscovery.model.HealthStatus
}
object HealthStatus {
  def wrap(
      value: software.amazon.awssdk.services.servicediscovery.model.HealthStatus
  ): io.github.vigoo.zioaws.servicediscovery.model.HealthStatus = value match {
    case software.amazon.awssdk.services.servicediscovery.model.HealthStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicediscovery.model.HealthStatus.HEALTHY =>
      val r = HEALTHY
      r
    case software.amazon.awssdk.services.servicediscovery.model.HealthStatus.UNHEALTHY =>
      val r = UNHEALTHY
      r
    case software.amazon.awssdk.services.servicediscovery.model.HealthStatus.UNKNOWN =>
      val r = UNKNOWN
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.servicediscovery.model.HealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.HealthStatus =
      software.amazon.awssdk.services.servicediscovery.model.HealthStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object HEALTHY
      extends io.github.vigoo.zioaws.servicediscovery.model.HealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.HealthStatus =
      software.amazon.awssdk.services.servicediscovery.model.HealthStatus.HEALTHY
  }
  case object UNHEALTHY
      extends io.github.vigoo.zioaws.servicediscovery.model.HealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.HealthStatus =
      software.amazon.awssdk.services.servicediscovery.model.HealthStatus.UNHEALTHY
  }
  case object UNKNOWN
      extends io.github.vigoo.zioaws.servicediscovery.model.HealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.HealthStatus =
      software.amazon.awssdk.services.servicediscovery.model.HealthStatus.UNKNOWN
  }
}
