package io.github.vigoo.zioaws.servicediscovery.model
import scala.jdk.CollectionConverters.*
sealed trait HealthStatusFilter {
  def unwrap: software.amazon.awssdk.services.servicediscovery.model.HealthStatusFilter
}
object HealthStatusFilter {
  def wrap(
      value: software.amazon.awssdk.services.servicediscovery.model.HealthStatusFilter
  ): io.github.vigoo.zioaws.servicediscovery.model.HealthStatusFilter =
    value match {
      case software.amazon.awssdk.services.servicediscovery.model.HealthStatusFilter.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.servicediscovery.model.HealthStatusFilter.HEALTHY =>
        val r = HEALTHY
        r
      case software.amazon.awssdk.services.servicediscovery.model.HealthStatusFilter.UNHEALTHY =>
        val r = UNHEALTHY
        r
      case software.amazon.awssdk.services.servicediscovery.model.HealthStatusFilter.ALL =>
        val r = ALL
        r
      case software.amazon.awssdk.services.servicediscovery.model.HealthStatusFilter.HEALTHY_OR_ELSE_ALL =>
        val r = HEALTHY_OR_ELSE_ALL
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.servicediscovery.model.HealthStatusFilter {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.HealthStatusFilter =
      software.amazon.awssdk.services.servicediscovery.model.HealthStatusFilter.UNKNOWN_TO_SDK_VERSION
  }
  case object HEALTHY
      extends io.github.vigoo.zioaws.servicediscovery.model.HealthStatusFilter {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.HealthStatusFilter =
      software.amazon.awssdk.services.servicediscovery.model.HealthStatusFilter.HEALTHY
  }
  case object UNHEALTHY
      extends io.github.vigoo.zioaws.servicediscovery.model.HealthStatusFilter {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.HealthStatusFilter =
      software.amazon.awssdk.services.servicediscovery.model.HealthStatusFilter.UNHEALTHY
  }
  case object ALL
      extends io.github.vigoo.zioaws.servicediscovery.model.HealthStatusFilter {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.HealthStatusFilter =
      software.amazon.awssdk.services.servicediscovery.model.HealthStatusFilter.ALL
  }
  case object HEALTHY_OR_ELSE_ALL
      extends io.github.vigoo.zioaws.servicediscovery.model.HealthStatusFilter {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.HealthStatusFilter =
      software.amazon.awssdk.services.servicediscovery.model.HealthStatusFilter.HEALTHY_OR_ELSE_ALL
  }
}
