package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.{
  NamespaceNameHttp,
  AttrKey,
  AttrValue,
  ServiceName,
  ResourceId
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class HttpInstanceSummary(
    instanceId: Option[ResourceId] = None,
    namespaceName: Option[NamespaceNameHttp] = None,
    serviceName: Option[ServiceName] = None,
    healthStatus: Option[
      io.github.vigoo.zioaws.servicediscovery.model.HealthStatus
    ] = None,
    attributes: Option[Map[AttrKey, AttrValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.HttpInstanceSummary = {
    import HttpInstanceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.HttpInstanceSummary
      .builder()
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(namespaceName.map(value => value: java.lang.String))(
        _.namespaceName
      )
      .optionallyWith(serviceName.map(value => value: java.lang.String))(
        _.serviceName
      )
      .optionallyWith(healthStatus.map(value => value.unwrap))(_.healthStatus)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.HttpInstanceSummary.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.HttpInstanceSummary
      .wrap(buildAwsValue())
}
object HttpInstanceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.HttpInstanceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.HttpInstanceSummary =
      io.github.vigoo.zioaws.servicediscovery.model.HttpInstanceSummary(
        instanceIdValue.map(value => value),
        namespaceNameValue.map(value => value),
        serviceNameValue.map(value => value),
        healthStatusValue.map(value => value),
        attributesValue.map(value => value)
      )
    def instanceIdValue: Option[ResourceId]
    def namespaceNameValue: Option[NamespaceNameHttp]
    def serviceNameValue: Option[ServiceName]
    def healthStatusValue
        : Option[io.github.vigoo.zioaws.servicediscovery.model.HealthStatus]
    def attributesValue: Option[Map[AttrKey, AttrValue]]
    def instanceId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("instanceId", instanceIdValue)
    def namespaceName: ZIO[Any, AwsError, NamespaceNameHttp] =
      AwsError.unwrapOptionField("namespaceName", namespaceNameValue)
    def serviceName: ZIO[Any, AwsError, ServiceName] =
      AwsError.unwrapOptionField("serviceName", serviceNameValue)
    def healthStatus: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.HealthStatus
    ] = AwsError.unwrapOptionField("healthStatus", healthStatusValue)
    def attributes: ZIO[Any, AwsError, Map[AttrKey, AttrValue]] =
      AwsError.unwrapOptionField("attributes", attributesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.HttpInstanceSummary
  ) extends io.github.vigoo.zioaws.servicediscovery.model.HttpInstanceSummary.ReadOnly {
    override def instanceIdValue: Option[ResourceId] =
      scala.Option(impl.instanceId()).map(value => value: ResourceId)
    override def namespaceNameValue: Option[NamespaceNameHttp] =
      scala.Option(impl.namespaceName()).map(value => value: NamespaceNameHttp)
    override def serviceNameValue: Option[ServiceName] =
      scala.Option(impl.serviceName()).map(value => value: ServiceName)
    override def healthStatusValue
        : Option[io.github.vigoo.zioaws.servicediscovery.model.HealthStatus] =
      scala
        .Option(impl.healthStatus())
        .map(value =>
          io.github.vigoo.zioaws.servicediscovery.model.HealthStatus.wrap(value)
        )
    override def attributesValue: Option[Map[AttrKey, AttrValue]] = scala
      .Option(impl.attributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: AttrKey) -> (value: AttrValue)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.HttpInstanceSummary
  ): io.github.vigoo.zioaws.servicediscovery.model.HttpInstanceSummary.ReadOnly =
    new Wrapper(impl)
}
