package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.ResourceDescription
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class HttpNamespaceChange(description: ResourceDescription) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.HttpNamespaceChange = {
    import HttpNamespaceChange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.HttpNamespaceChange
      .builder()
      .description(description: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.HttpNamespaceChange.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.HttpNamespaceChange
      .wrap(buildAwsValue())
}
object HttpNamespaceChange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.HttpNamespaceChange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.HttpNamespaceChange =
      io.github.vigoo.zioaws.servicediscovery.model
        .HttpNamespaceChange(descriptionValue)
    def descriptionValue: ResourceDescription
    def description: ZIO[Any, Nothing, ResourceDescription] =
      ZIO.succeed(descriptionValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.HttpNamespaceChange
  ) extends io.github.vigoo.zioaws.servicediscovery.model.HttpNamespaceChange.ReadOnly {
    override def descriptionValue: ResourceDescription =
      impl.description(): ResourceDescription
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.HttpNamespaceChange
  ): io.github.vigoo.zioaws.servicediscovery.model.HttpNamespaceChange.ReadOnly =
    new Wrapper(impl)
}
