package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.NamespaceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class HttpProperties(httpName: Option[NamespaceName] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.HttpProperties = {
    import HttpProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.HttpProperties
      .builder()
      .optionallyWith(httpName.map(value => value: java.lang.String))(
        _.httpName
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.HttpProperties.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.HttpProperties
      .wrap(buildAwsValue())
}
object HttpProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.HttpProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.servicediscovery.model.HttpProperties =
      io.github.vigoo.zioaws.servicediscovery.model
        .HttpProperties(httpNameValue.map(value => value))
    def httpNameValue: Option[NamespaceName]
    def httpName: ZIO[Any, AwsError, NamespaceName] =
      AwsError.unwrapOptionField("httpName", httpNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.HttpProperties
  ) extends io.github.vigoo.zioaws.servicediscovery.model.HttpProperties.ReadOnly {
    override def httpNameValue: Option[NamespaceName] =
      scala.Option(impl.httpName()).map(value => value: NamespaceName)
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.HttpProperties
  ): io.github.vigoo.zioaws.servicediscovery.model.HttpProperties.ReadOnly =
    new Wrapper(impl)
}
