package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.{
  AttrValue,
  AttrKey,
  ResourceId
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Instance(
    id: ResourceId,
    creatorRequestId: Option[ResourceId] = None,
    attributes: Option[Map[AttrKey, AttrValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.Instance = {
    import Instance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.Instance
      .builder()
      .id(id: java.lang.String)
      .optionallyWith(creatorRequestId.map(value => value: java.lang.String))(
        _.creatorRequestId
      )
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.Instance.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.Instance.wrap(buildAwsValue())
}
object Instance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.Instance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.servicediscovery.model.Instance =
      io.github.vigoo.zioaws.servicediscovery.model.Instance(
        idValue,
        creatorRequestIdValue.map(value => value),
        attributesValue.map(value => value)
      )
    def idValue: ResourceId
    def creatorRequestIdValue: Option[ResourceId]
    def attributesValue: Option[Map[AttrKey, AttrValue]]
    def id: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(idValue)
    def creatorRequestId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestIdValue)
    def attributes: ZIO[Any, AwsError, Map[AttrKey, AttrValue]] =
      AwsError.unwrapOptionField("attributes", attributesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.Instance
  ) extends io.github.vigoo.zioaws.servicediscovery.model.Instance.ReadOnly {
    override def idValue: ResourceId = impl.id(): ResourceId
    override def creatorRequestIdValue: Option[ResourceId] =
      scala.Option(impl.creatorRequestId()).map(value => value: ResourceId)
    override def attributesValue: Option[Map[AttrKey, AttrValue]] = scala
      .Option(impl.attributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: AttrKey) -> (value: AttrValue)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.Instance
  ): io.github.vigoo.zioaws.servicediscovery.model.Instance.ReadOnly =
    new Wrapper(impl)
}
