package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.{
  AttrValue,
  AttrKey,
  ResourceId
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InstanceSummary(
    id: Option[ResourceId] = None,
    attributes: Option[Map[AttrKey, AttrValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.InstanceSummary = {
    import InstanceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.InstanceSummary
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.InstanceSummary.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.InstanceSummary
      .wrap(buildAwsValue())
}
object InstanceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.InstanceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.InstanceSummary =
      io.github.vigoo.zioaws.servicediscovery.model.InstanceSummary(
        idValue.map(value => value),
        attributesValue.map(value => value)
      )
    def idValue: Option[ResourceId]
    def attributesValue: Option[Map[AttrKey, AttrValue]]
    def id: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("id", idValue)
    def attributes: ZIO[Any, AwsError, Map[AttrKey, AttrValue]] =
      AwsError.unwrapOptionField("attributes", attributesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.InstanceSummary
  ) extends io.github.vigoo.zioaws.servicediscovery.model.InstanceSummary.ReadOnly {
    override def idValue: Option[ResourceId] =
      scala.Option(impl.id()).map(value => value: ResourceId)
    override def attributesValue: Option[Map[AttrKey, AttrValue]] = scala
      .Option(impl.attributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: AttrKey) -> (value: AttrValue)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.InstanceSummary
  ): io.github.vigoo.zioaws.servicediscovery.model.InstanceSummary.ReadOnly =
    new Wrapper(impl)
}
