package io.github.vigoo.zioaws.servicediscovery.model
import java.lang.Integer
import io.github.vigoo.zioaws.servicediscovery.model.primitives.{
  MaxResults,
  NextToken,
  ResourceId
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListInstancesRequest(
    serviceId: ResourceId,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.ListInstancesRequest = {
    import ListInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.ListInstancesRequest
      .builder()
      .serviceId(serviceId: java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.ListInstancesRequest.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.ListInstancesRequest
      .wrap(buildAwsValue())
}
object ListInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.ListInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.ListInstancesRequest =
      io.github.vigoo.zioaws.servicediscovery.model.ListInstancesRequest(
        serviceIdValue,
        nextTokenValue.map(value => value),
        maxResultsValue.map(value => value)
      )
    def serviceIdValue: ResourceId
    def nextTokenValue: Option[NextToken]
    def maxResultsValue: Option[MaxResults]
    def serviceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(serviceIdValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.ListInstancesRequest
  ) extends io.github.vigoo.zioaws.servicediscovery.model.ListInstancesRequest.ReadOnly {
    override def serviceIdValue: ResourceId = impl.serviceId(): ResourceId
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
    override def maxResultsValue: Option[MaxResults] =
      scala.Option(impl.maxResults()).map(value => value: MaxResults)
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.ListInstancesRequest
  ): io.github.vigoo.zioaws.servicediscovery.model.ListInstancesRequest.ReadOnly =
    new Wrapper(impl)
}
