package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.NextToken
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListInstancesResponse(
    instances: Option[
      Iterable[io.github.vigoo.zioaws.servicediscovery.model.InstanceSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.ListInstancesResponse = {
    import ListInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.ListInstancesResponse
      .builder()
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.ListInstancesResponse.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.ListInstancesResponse
      .wrap(buildAwsValue())
}
object ListInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.ListInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.ListInstancesResponse =
      io.github.vigoo.zioaws.servicediscovery.model.ListInstancesResponse(
        instancesValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value)
      )
    def instancesValue: Option[List[
      io.github.vigoo.zioaws.servicediscovery.model.InstanceSummary.ReadOnly
    ]]
    def nextTokenValue: Option[NextToken]
    def instances: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.servicediscovery.model.InstanceSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("instances", instancesValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.ListInstancesResponse
  ) extends io.github.vigoo.zioaws.servicediscovery.model.ListInstancesResponse.ReadOnly {
    override def instancesValue: Option[List[
      io.github.vigoo.zioaws.servicediscovery.model.InstanceSummary.ReadOnly
    ]] = scala
      .Option(impl.instances())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.servicediscovery.model.InstanceSummary
            .wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.ListInstancesResponse
  ): io.github.vigoo.zioaws.servicediscovery.model.ListInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
