package io.github.vigoo.zioaws.servicediscovery.model
import java.lang.Integer
import io.github.vigoo.zioaws.servicediscovery.model.primitives.{
  MaxResults,
  NextToken
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListNamespacesRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    filters: Option[
      Iterable[io.github.vigoo.zioaws.servicediscovery.model.NamespaceFilter]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.ListNamespacesRequest = {
    import ListNamespacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.ListNamespacesRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.ListNamespacesRequest.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.ListNamespacesRequest
      .wrap(buildAwsValue())
}
object ListNamespacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.ListNamespacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.ListNamespacesRequest =
      io.github.vigoo.zioaws.servicediscovery.model.ListNamespacesRequest(
        nextTokenValue.map(value => value),
        maxResultsValue.map(value => value),
        filtersValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def nextTokenValue: Option[NextToken]
    def maxResultsValue: Option[MaxResults]
    def filtersValue: Option[List[
      io.github.vigoo.zioaws.servicediscovery.model.NamespaceFilter.ReadOnly
    ]]
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def filters: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.servicediscovery.model.NamespaceFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filtersValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.ListNamespacesRequest
  ) extends io.github.vigoo.zioaws.servicediscovery.model.ListNamespacesRequest.ReadOnly {
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
    override def maxResultsValue: Option[MaxResults] =
      scala.Option(impl.maxResults()).map(value => value: MaxResults)
    override def filtersValue: Option[List[
      io.github.vigoo.zioaws.servicediscovery.model.NamespaceFilter.ReadOnly
    ]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.servicediscovery.model.NamespaceFilter
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.ListNamespacesRequest
  ): io.github.vigoo.zioaws.servicediscovery.model.ListNamespacesRequest.ReadOnly =
    new Wrapper(impl)
}
