package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.NextToken
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListNamespacesResponse(
    namespaces: Option[
      Iterable[io.github.vigoo.zioaws.servicediscovery.model.NamespaceSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.ListNamespacesResponse = {
    import ListNamespacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.ListNamespacesResponse
      .builder()
      .optionallyWith(
        namespaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.namespaces)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.ListNamespacesResponse.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.ListNamespacesResponse
      .wrap(buildAwsValue())
}
object ListNamespacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.ListNamespacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.ListNamespacesResponse =
      io.github.vigoo.zioaws.servicediscovery.model.ListNamespacesResponse(
        namespacesValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value)
      )
    def namespacesValue: Option[List[
      io.github.vigoo.zioaws.servicediscovery.model.NamespaceSummary.ReadOnly
    ]]
    def nextTokenValue: Option[NextToken]
    def namespaces: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.servicediscovery.model.NamespaceSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("namespaces", namespacesValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.ListNamespacesResponse
  ) extends io.github.vigoo.zioaws.servicediscovery.model.ListNamespacesResponse.ReadOnly {
    override def namespacesValue: Option[List[
      io.github.vigoo.zioaws.servicediscovery.model.NamespaceSummary.ReadOnly
    ]] = scala
      .Option(impl.namespaces())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.servicediscovery.model.NamespaceSummary
            .wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.ListNamespacesResponse
  ): io.github.vigoo.zioaws.servicediscovery.model.ListNamespacesResponse.ReadOnly =
    new Wrapper(impl)
}
