package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.NextToken
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListOperationsResponse(
    operations: Option[
      Iterable[io.github.vigoo.zioaws.servicediscovery.model.OperationSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.ListOperationsResponse = {
    import ListOperationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.ListOperationsResponse
      .builder()
      .optionallyWith(
        operations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.ListOperationsResponse.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.ListOperationsResponse
      .wrap(buildAwsValue())
}
object ListOperationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.ListOperationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.ListOperationsResponse =
      io.github.vigoo.zioaws.servicediscovery.model.ListOperationsResponse(
        operationsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value)
      )
    def operationsValue: Option[List[
      io.github.vigoo.zioaws.servicediscovery.model.OperationSummary.ReadOnly
    ]]
    def nextTokenValue: Option[NextToken]
    def operations: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.servicediscovery.model.OperationSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("operations", operationsValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.ListOperationsResponse
  ) extends io.github.vigoo.zioaws.servicediscovery.model.ListOperationsResponse.ReadOnly {
    override def operationsValue: Option[List[
      io.github.vigoo.zioaws.servicediscovery.model.OperationSummary.ReadOnly
    ]] = scala
      .Option(impl.operations())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.servicediscovery.model.OperationSummary
            .wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.ListOperationsResponse
  ): io.github.vigoo.zioaws.servicediscovery.model.ListOperationsResponse.ReadOnly =
    new Wrapper(impl)
}
