package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.NextToken
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListServicesResponse(
    services: Option[
      Iterable[io.github.vigoo.zioaws.servicediscovery.model.ServiceSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.ListServicesResponse = {
    import ListServicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.ListServicesResponse
      .builder()
      .optionallyWith(
        services.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.services)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.ListServicesResponse.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.ListServicesResponse
      .wrap(buildAwsValue())
}
object ListServicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.ListServicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.ListServicesResponse =
      io.github.vigoo.zioaws.servicediscovery.model.ListServicesResponse(
        servicesValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value)
      )
    def servicesValue: Option[List[
      io.github.vigoo.zioaws.servicediscovery.model.ServiceSummary.ReadOnly
    ]]
    def nextTokenValue: Option[NextToken]
    def services: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.servicediscovery.model.ServiceSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("services", servicesValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.ListServicesResponse
  ) extends io.github.vigoo.zioaws.servicediscovery.model.ListServicesResponse.ReadOnly {
    override def servicesValue: Option[List[
      io.github.vigoo.zioaws.servicediscovery.model.ServiceSummary.ReadOnly
    ]] = scala
      .Option(impl.services())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.servicediscovery.model.ServiceSummary
            .wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.ListServicesResponse
  ): io.github.vigoo.zioaws.servicediscovery.model.ListServicesResponse.ReadOnly =
    new Wrapper(impl)
}
