package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.AmazonResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceARN: AmazonResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.ListTagsForResourceRequest
      .builder()
      .resourceARN(resourceARN: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.ListTagsForResourceRequest.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.ListTagsForResourceRequest =
      io.github.vigoo.zioaws.servicediscovery.model
        .ListTagsForResourceRequest(resourceARNValue)
    def resourceARNValue: AmazonResourceName
    def resourceARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceARNValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.ListTagsForResourceRequest
  ) extends io.github.vigoo.zioaws.servicediscovery.model.ListTagsForResourceRequest.ReadOnly {
    override def resourceARNValue: AmazonResourceName =
      impl.resourceARN(): AmazonResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.ListTagsForResourceRequest
  ): io.github.vigoo.zioaws.servicediscovery.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
