package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.ZIO
import io.github.vigoo.zioaws.servicediscovery.model.primitives.{
  ResourceDescription,
  Timestamp,
  NamespaceName,
  Arn,
  ResourceCount,
  ResourceId
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Namespace(
    id: Option[ResourceId] = None,
    arn: Option[Arn] = None,
    name: Option[NamespaceName] = None,
    `type`: Option[
      io.github.vigoo.zioaws.servicediscovery.model.NamespaceType
    ] = None,
    description: Option[ResourceDescription] = None,
    serviceCount: Option[ResourceCount] = None,
    properties: Option[
      io.github.vigoo.zioaws.servicediscovery.model.NamespaceProperties
    ] = None,
    createDate: Option[Timestamp] = None,
    creatorRequestId: Option[ResourceId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.Namespace = {
    import Namespace.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.Namespace
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(serviceCount.map(value => value: Integer))(_.serviceCount)
      .optionallyWith(properties.map(value => value.buildAwsValue()))(
        _.properties
      )
      .optionallyWith(createDate.map(value => value: Instant))(_.createDate)
      .optionallyWith(creatorRequestId.map(value => value: java.lang.String))(
        _.creatorRequestId
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.Namespace.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.Namespace
      .wrap(buildAwsValue())
}
object Namespace {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.Namespace
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.servicediscovery.model.Namespace =
      io.github.vigoo.zioaws.servicediscovery.model.Namespace(
        idValue.map(value => value),
        arnValue.map(value => value),
        nameValue.map(value => value),
        typeValue.map(value => value),
        descriptionValue.map(value => value),
        serviceCountValue.map(value => value),
        propertiesValue.map(value => value.editable),
        createDateValue.map(value => value),
        creatorRequestIdValue.map(value => value)
      )
    def idValue: Option[ResourceId]
    def arnValue: Option[Arn]
    def nameValue: Option[NamespaceName]
    def typeValue
        : Option[io.github.vigoo.zioaws.servicediscovery.model.NamespaceType]
    def descriptionValue: Option[ResourceDescription]
    def serviceCountValue: Option[ResourceCount]
    def propertiesValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.NamespaceProperties.ReadOnly
    ]
    def createDateValue: Option[Timestamp]
    def creatorRequestIdValue: Option[ResourceId]
    def id: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("id", idValue)
    def arn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("arn", arnValue)
    def name: ZIO[Any, AwsError, NamespaceName] =
      AwsError.unwrapOptionField("name", nameValue)
    def `type`: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.NamespaceType
    ] = AwsError.unwrapOptionField("type", typeValue)
    def description: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def serviceCount: ZIO[Any, AwsError, ResourceCount] =
      AwsError.unwrapOptionField("serviceCount", serviceCountValue)
    def properties: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.NamespaceProperties.ReadOnly
    ] = AwsError.unwrapOptionField("properties", propertiesValue)
    def createDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createDate", createDateValue)
    def creatorRequestId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.Namespace
  ) extends io.github.vigoo.zioaws.servicediscovery.model.Namespace.ReadOnly {
    override def idValue: Option[ResourceId] =
      scala.Option(impl.id()).map(value => value: ResourceId)
    override def arnValue: Option[Arn] =
      scala.Option(impl.arn()).map(value => value: Arn)
    override def nameValue: Option[NamespaceName] =
      scala.Option(impl.name()).map(value => value: NamespaceName)
    override def typeValue
        : Option[io.github.vigoo.zioaws.servicediscovery.model.NamespaceType] =
      scala
        .Option(impl.`type`())
        .map(value =>
          io.github.vigoo.zioaws.servicediscovery.model.NamespaceType
            .wrap(value)
        )
    override def descriptionValue: Option[ResourceDescription] =
      scala.Option(impl.description()).map(value => value: ResourceDescription)
    override def serviceCountValue: Option[ResourceCount] =
      scala.Option(impl.serviceCount()).map(value => value: ResourceCount)
    override def propertiesValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.NamespaceProperties.ReadOnly
    ] = scala
      .Option(impl.properties())
      .map(value =>
        io.github.vigoo.zioaws.servicediscovery.model.NamespaceProperties
          .wrap(value)
      )
    override def createDateValue: Option[Timestamp] =
      scala.Option(impl.createDate()).map(value => value: Timestamp)
    override def creatorRequestIdValue: Option[ResourceId] =
      scala.Option(impl.creatorRequestId()).map(value => value: ResourceId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.Namespace
  ): io.github.vigoo.zioaws.servicediscovery.model.Namespace.ReadOnly =
    new Wrapper(impl)
}
