package io.github.vigoo.zioaws.servicediscovery.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NamespaceProperties(
    dnsProperties: Option[
      io.github.vigoo.zioaws.servicediscovery.model.DnsProperties
    ] = None,
    httpProperties: Option[
      io.github.vigoo.zioaws.servicediscovery.model.HttpProperties
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.NamespaceProperties = {
    import NamespaceProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.NamespaceProperties
      .builder()
      .optionallyWith(dnsProperties.map(value => value.buildAwsValue()))(
        _.dnsProperties
      )
      .optionallyWith(httpProperties.map(value => value.buildAwsValue()))(
        _.httpProperties
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.NamespaceProperties.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.NamespaceProperties
      .wrap(buildAwsValue())
}
object NamespaceProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.NamespaceProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.NamespaceProperties =
      io.github.vigoo.zioaws.servicediscovery.model.NamespaceProperties(
        dnsPropertiesValue.map(value => value.editable),
        httpPropertiesValue.map(value => value.editable)
      )
    def dnsPropertiesValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.DnsProperties.ReadOnly
    ]
    def httpPropertiesValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.HttpProperties.ReadOnly
    ]
    def dnsProperties: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.DnsProperties.ReadOnly
    ] = AwsError.unwrapOptionField("dnsProperties", dnsPropertiesValue)
    def httpProperties: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.HttpProperties.ReadOnly
    ] = AwsError.unwrapOptionField("httpProperties", httpPropertiesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.NamespaceProperties
  ) extends io.github.vigoo.zioaws.servicediscovery.model.NamespaceProperties.ReadOnly {
    override def dnsPropertiesValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.DnsProperties.ReadOnly
    ] = scala
      .Option(impl.dnsProperties())
      .map(value =>
        io.github.vigoo.zioaws.servicediscovery.model.DnsProperties.wrap(value)
      )
    override def httpPropertiesValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.HttpProperties.ReadOnly
    ] = scala
      .Option(impl.httpProperties())
      .map(value =>
        io.github.vigoo.zioaws.servicediscovery.model.HttpProperties.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.NamespaceProperties
  ): io.github.vigoo.zioaws.servicediscovery.model.NamespaceProperties.ReadOnly =
    new Wrapper(impl)
}
