package io.github.vigoo.zioaws.servicediscovery.model
import scala.jdk.CollectionConverters.*
sealed trait NamespaceType {
  def unwrap
      : software.amazon.awssdk.services.servicediscovery.model.NamespaceType
}
object NamespaceType {
  def wrap(
      value: software.amazon.awssdk.services.servicediscovery.model.NamespaceType
  ): io.github.vigoo.zioaws.servicediscovery.model.NamespaceType = value match {
    case software.amazon.awssdk.services.servicediscovery.model.NamespaceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicediscovery.model.NamespaceType.DNS_PUBLIC =>
      val r = DNS_PUBLIC
      r
    case software.amazon.awssdk.services.servicediscovery.model.NamespaceType.DNS_PRIVATE =>
      val r = DNS_PRIVATE
      r
    case software.amazon.awssdk.services.servicediscovery.model.NamespaceType.HTTP =>
      val r = HTTP
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.servicediscovery.model.NamespaceType {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.NamespaceType =
      software.amazon.awssdk.services.servicediscovery.model.NamespaceType.UNKNOWN_TO_SDK_VERSION
  }
  case object DNS_PUBLIC
      extends io.github.vigoo.zioaws.servicediscovery.model.NamespaceType {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.NamespaceType =
      software.amazon.awssdk.services.servicediscovery.model.NamespaceType.DNS_PUBLIC
  }
  case object DNS_PRIVATE
      extends io.github.vigoo.zioaws.servicediscovery.model.NamespaceType {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.NamespaceType =
      software.amazon.awssdk.services.servicediscovery.model.NamespaceType.DNS_PRIVATE
  }
  case object HTTP
      extends io.github.vigoo.zioaws.servicediscovery.model.NamespaceType {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.NamespaceType =
      software.amazon.awssdk.services.servicediscovery.model.NamespaceType.HTTP
  }
}
