package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.{
  Message,
  OperationId,
  Timestamp,
  Code,
  ResourceId
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Operation(
    id: Option[OperationId] = None,
    `type`: Option[
      io.github.vigoo.zioaws.servicediscovery.model.OperationType
    ] = None,
    status: Option[
      io.github.vigoo.zioaws.servicediscovery.model.OperationStatus
    ] = None,
    errorMessage: Option[Message] = None,
    errorCode: Option[Code] = None,
    createDate: Option[Timestamp] = None,
    updateDate: Option[Timestamp] = None,
    targets: Option[Map[
      io.github.vigoo.zioaws.servicediscovery.model.OperationTargetType,
      ResourceId
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.Operation = {
    import Operation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.Operation
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(createDate.map(value => value: Instant))(_.createDate)
      .optionallyWith(updateDate.map(value => value: Instant))(_.updateDate)
      .optionallyWith(
        targets.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.targetsWithStrings)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.Operation.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.Operation
      .wrap(buildAwsValue())
}
object Operation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.Operation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.servicediscovery.model.Operation =
      io.github.vigoo.zioaws.servicediscovery.model.Operation(
        idValue.map(value => value),
        typeValue.map(value => value),
        statusValue.map(value => value),
        errorMessageValue.map(value => value),
        errorCodeValue.map(value => value),
        createDateValue.map(value => value),
        updateDateValue.map(value => value),
        targetsValue.map(value => value)
      )
    def idValue: Option[OperationId]
    def typeValue
        : Option[io.github.vigoo.zioaws.servicediscovery.model.OperationType]
    def statusValue
        : Option[io.github.vigoo.zioaws.servicediscovery.model.OperationStatus]
    def errorMessageValue: Option[Message]
    def errorCodeValue: Option[Code]
    def createDateValue: Option[Timestamp]
    def updateDateValue: Option[Timestamp]
    def targetsValue: Option[Map[
      io.github.vigoo.zioaws.servicediscovery.model.OperationTargetType,
      ResourceId
    ]]
    def id: ZIO[Any, AwsError, OperationId] =
      AwsError.unwrapOptionField("id", idValue)
    def `type`: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.OperationType
    ] = AwsError.unwrapOptionField("type", typeValue)
    def status: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.OperationStatus
    ] = AwsError.unwrapOptionField("status", statusValue)
    def errorMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("errorMessage", errorMessageValue)
    def errorCode: ZIO[Any, AwsError, Code] =
      AwsError.unwrapOptionField("errorCode", errorCodeValue)
    def createDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createDate", createDateValue)
    def updateDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updateDate", updateDateValue)
    def targets: ZIO[Any, AwsError, Map[
      io.github.vigoo.zioaws.servicediscovery.model.OperationTargetType,
      ResourceId
    ]] = AwsError.unwrapOptionField("targets", targetsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.Operation
  ) extends io.github.vigoo.zioaws.servicediscovery.model.Operation.ReadOnly {
    override def idValue: Option[OperationId] =
      scala.Option(impl.id()).map(value => value: OperationId)
    override def typeValue
        : Option[io.github.vigoo.zioaws.servicediscovery.model.OperationType] =
      scala
        .Option(impl.`type`())
        .map(value =>
          io.github.vigoo.zioaws.servicediscovery.model.OperationType
            .wrap(value)
        )
    override def statusValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.OperationStatus
    ] = scala
      .Option(impl.status())
      .map(value =>
        io.github.vigoo.zioaws.servicediscovery.model.OperationStatus
          .wrap(value)
      )
    override def errorMessageValue: Option[Message] =
      scala.Option(impl.errorMessage()).map(value => value: Message)
    override def errorCodeValue: Option[Code] =
      scala.Option(impl.errorCode()).map(value => value: Code)
    override def createDateValue: Option[Timestamp] =
      scala.Option(impl.createDate()).map(value => value: Timestamp)
    override def updateDateValue: Option[Timestamp] =
      scala.Option(impl.updateDate()).map(value => value: Timestamp)
    override def targetsValue: Option[Map[
      io.github.vigoo.zioaws.servicediscovery.model.OperationTargetType,
      ResourceId
    ]] = scala
      .Option(impl.targets())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            io.github.vigoo.zioaws.servicediscovery.model.OperationTargetType
              .wrap(key) -> (value: ResourceId)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.Operation
  ): io.github.vigoo.zioaws.servicediscovery.model.Operation.ReadOnly =
    new Wrapper(impl)
}
