package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.FilterValue
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class OperationFilter(
    name: io.github.vigoo.zioaws.servicediscovery.model.OperationFilterName,
    values: Iterable[FilterValue],
    condition: Option[
      io.github.vigoo.zioaws.servicediscovery.model.FilterCondition
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.OperationFilter = {
    import OperationFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.OperationFilter
      .builder()
      .name(name.unwrap)
      .values(values.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(condition.map(value => value.unwrap))(_.condition)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.OperationFilter.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.OperationFilter
      .wrap(buildAwsValue())
}
object OperationFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.OperationFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.OperationFilter =
      io.github.vigoo.zioaws.servicediscovery.model.OperationFilter(
        nameValue,
        valuesValue,
        conditionValue.map(value => value)
      )
    def nameValue
        : io.github.vigoo.zioaws.servicediscovery.model.OperationFilterName
    def valuesValue: List[FilterValue]
    def conditionValue
        : Option[io.github.vigoo.zioaws.servicediscovery.model.FilterCondition]
    def name: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.servicediscovery.model.OperationFilterName
    ] = ZIO.succeed(nameValue)
    def values: ZIO[Any, Nothing, List[FilterValue]] = ZIO.succeed(valuesValue)
    def condition: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.FilterCondition
    ] = AwsError.unwrapOptionField("condition", conditionValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.OperationFilter
  ) extends io.github.vigoo.zioaws.servicediscovery.model.OperationFilter.ReadOnly {
    override def nameValue
        : io.github.vigoo.zioaws.servicediscovery.model.OperationFilterName =
      io.github.vigoo.zioaws.servicediscovery.model.OperationFilterName
        .wrap(impl.name())
    override def valuesValue: List[FilterValue] = impl
      .values()
      .asScala
      .map { item =>
        item: FilterValue
      }
      .toList
    override def conditionValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.FilterCondition
    ] = scala
      .Option(impl.condition())
      .map(value =>
        io.github.vigoo.zioaws.servicediscovery.model.FilterCondition
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.OperationFilter
  ): io.github.vigoo.zioaws.servicediscovery.model.OperationFilter.ReadOnly =
    new Wrapper(impl)
}
