package io.github.vigoo.zioaws.servicediscovery.model
import scala.jdk.CollectionConverters.*
sealed trait OperationStatus {
  def unwrap
      : software.amazon.awssdk.services.servicediscovery.model.OperationStatus
}
object OperationStatus {
  def wrap(
      value: software.amazon.awssdk.services.servicediscovery.model.OperationStatus
  ): io.github.vigoo.zioaws.servicediscovery.model.OperationStatus =
    value match {
      case software.amazon.awssdk.services.servicediscovery.model.OperationStatus.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.servicediscovery.model.OperationStatus.SUBMITTED =>
        val r = SUBMITTED
        r
      case software.amazon.awssdk.services.servicediscovery.model.OperationStatus.PENDING =>
        val r = PENDING
        r
      case software.amazon.awssdk.services.servicediscovery.model.OperationStatus.SUCCESS =>
        val r = SUCCESS
        r
      case software.amazon.awssdk.services.servicediscovery.model.OperationStatus.FAIL =>
        val r = FAIL
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.servicediscovery.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.OperationStatus =
      software.amazon.awssdk.services.servicediscovery.model.OperationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SUBMITTED
      extends io.github.vigoo.zioaws.servicediscovery.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.OperationStatus =
      software.amazon.awssdk.services.servicediscovery.model.OperationStatus.SUBMITTED
  }
  case object PENDING
      extends io.github.vigoo.zioaws.servicediscovery.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.OperationStatus =
      software.amazon.awssdk.services.servicediscovery.model.OperationStatus.PENDING
  }
  case object SUCCESS
      extends io.github.vigoo.zioaws.servicediscovery.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.OperationStatus =
      software.amazon.awssdk.services.servicediscovery.model.OperationStatus.SUCCESS
  }
  case object FAIL
      extends io.github.vigoo.zioaws.servicediscovery.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.OperationStatus =
      software.amazon.awssdk.services.servicediscovery.model.OperationStatus.FAIL
  }
}
