package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.OperationId
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class OperationSummary(
    id: Option[OperationId] = None,
    status: Option[
      io.github.vigoo.zioaws.servicediscovery.model.OperationStatus
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.OperationSummary = {
    import OperationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.OperationSummary
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.OperationSummary.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.OperationSummary
      .wrap(buildAwsValue())
}
object OperationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.OperationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.OperationSummary =
      io.github.vigoo.zioaws.servicediscovery.model.OperationSummary(
        idValue.map(value => value),
        statusValue.map(value => value)
      )
    def idValue: Option[OperationId]
    def statusValue
        : Option[io.github.vigoo.zioaws.servicediscovery.model.OperationStatus]
    def id: ZIO[Any, AwsError, OperationId] =
      AwsError.unwrapOptionField("id", idValue)
    def status: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.OperationStatus
    ] = AwsError.unwrapOptionField("status", statusValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.OperationSummary
  ) extends io.github.vigoo.zioaws.servicediscovery.model.OperationSummary.ReadOnly {
    override def idValue: Option[OperationId] =
      scala.Option(impl.id()).map(value => value: OperationId)
    override def statusValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.OperationStatus
    ] = scala
      .Option(impl.status())
      .map(value =>
        io.github.vigoo.zioaws.servicediscovery.model.OperationStatus
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.OperationSummary
  ): io.github.vigoo.zioaws.servicediscovery.model.OperationSummary.ReadOnly =
    new Wrapper(impl)
}
