package io.github.vigoo.zioaws.servicediscovery.model
import scala.jdk.CollectionConverters.*
sealed trait OperationTargetType {
  def unwrap: software.amazon.awssdk.services.servicediscovery.model.OperationTargetType
}
object OperationTargetType {
  def wrap(
      value: software.amazon.awssdk.services.servicediscovery.model.OperationTargetType
  ): io.github.vigoo.zioaws.servicediscovery.model.OperationTargetType =
    value match {
      case software.amazon.awssdk.services.servicediscovery.model.OperationTargetType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.servicediscovery.model.OperationTargetType.NAMESPACE =>
        val r = NAMESPACE
        r
      case software.amazon.awssdk.services.servicediscovery.model.OperationTargetType.SERVICE =>
        val r = SERVICE
        r
      case software.amazon.awssdk.services.servicediscovery.model.OperationTargetType.INSTANCE =>
        val r = INSTANCE
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.servicediscovery.model.OperationTargetType {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.OperationTargetType =
      software.amazon.awssdk.services.servicediscovery.model.OperationTargetType.UNKNOWN_TO_SDK_VERSION
  }
  case object NAMESPACE
      extends io.github.vigoo.zioaws.servicediscovery.model.OperationTargetType {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.OperationTargetType =
      software.amazon.awssdk.services.servicediscovery.model.OperationTargetType.NAMESPACE
  }
  case object SERVICE
      extends io.github.vigoo.zioaws.servicediscovery.model.OperationTargetType {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.OperationTargetType =
      software.amazon.awssdk.services.servicediscovery.model.OperationTargetType.SERVICE
  }
  case object INSTANCE
      extends io.github.vigoo.zioaws.servicediscovery.model.OperationTargetType {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.OperationTargetType =
      software.amazon.awssdk.services.servicediscovery.model.OperationTargetType.INSTANCE
  }
}
