package io.github.vigoo.zioaws.servicediscovery.model
import scala.jdk.CollectionConverters.*
sealed trait OperationType {
  def unwrap
      : software.amazon.awssdk.services.servicediscovery.model.OperationType
}
object OperationType {
  def wrap(
      value: software.amazon.awssdk.services.servicediscovery.model.OperationType
  ): io.github.vigoo.zioaws.servicediscovery.model.OperationType = value match {
    case software.amazon.awssdk.services.servicediscovery.model.OperationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicediscovery.model.OperationType.CREATE_NAMESPACE =>
      val r = CREATE_NAMESPACE
      r
    case software.amazon.awssdk.services.servicediscovery.model.OperationType.DELETE_NAMESPACE =>
      val r = DELETE_NAMESPACE
      r
    case software.amazon.awssdk.services.servicediscovery.model.OperationType.UPDATE_NAMESPACE =>
      val r = UPDATE_NAMESPACE
      r
    case software.amazon.awssdk.services.servicediscovery.model.OperationType.UPDATE_SERVICE =>
      val r = UPDATE_SERVICE
      r
    case software.amazon.awssdk.services.servicediscovery.model.OperationType.REGISTER_INSTANCE =>
      val r = REGISTER_INSTANCE
      r
    case software.amazon.awssdk.services.servicediscovery.model.OperationType.DEREGISTER_INSTANCE =>
      val r = DEREGISTER_INSTANCE
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.servicediscovery.model.OperationType {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.OperationType =
      software.amazon.awssdk.services.servicediscovery.model.OperationType.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE_NAMESPACE
      extends io.github.vigoo.zioaws.servicediscovery.model.OperationType {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.OperationType =
      software.amazon.awssdk.services.servicediscovery.model.OperationType.CREATE_NAMESPACE
  }
  case object DELETE_NAMESPACE
      extends io.github.vigoo.zioaws.servicediscovery.model.OperationType {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.OperationType =
      software.amazon.awssdk.services.servicediscovery.model.OperationType.DELETE_NAMESPACE
  }
  case object UPDATE_NAMESPACE
      extends io.github.vigoo.zioaws.servicediscovery.model.OperationType {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.OperationType =
      software.amazon.awssdk.services.servicediscovery.model.OperationType.UPDATE_NAMESPACE
  }
  case object UPDATE_SERVICE
      extends io.github.vigoo.zioaws.servicediscovery.model.OperationType {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.OperationType =
      software.amazon.awssdk.services.servicediscovery.model.OperationType.UPDATE_SERVICE
  }
  case object REGISTER_INSTANCE
      extends io.github.vigoo.zioaws.servicediscovery.model.OperationType {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.OperationType =
      software.amazon.awssdk.services.servicediscovery.model.OperationType.REGISTER_INSTANCE
  }
  case object DEREGISTER_INSTANCE
      extends io.github.vigoo.zioaws.servicediscovery.model.OperationType {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.OperationType =
      software.amazon.awssdk.services.servicediscovery.model.OperationType.DEREGISTER_INSTANCE
  }
}
