package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.ResourceDescription
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PrivateDnsNamespaceChange(
    description: Option[ResourceDescription] = None,
    properties: Option[
      io.github.vigoo.zioaws.servicediscovery.model.PrivateDnsNamespacePropertiesChange
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.PrivateDnsNamespaceChange = {
    import PrivateDnsNamespaceChange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.PrivateDnsNamespaceChange
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(properties.map(value => value.buildAwsValue()))(
        _.properties
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.PrivateDnsNamespaceChange.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.PrivateDnsNamespaceChange
      .wrap(buildAwsValue())
}
object PrivateDnsNamespaceChange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.PrivateDnsNamespaceChange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.PrivateDnsNamespaceChange =
      io.github.vigoo.zioaws.servicediscovery.model.PrivateDnsNamespaceChange(
        descriptionValue.map(value => value),
        propertiesValue.map(value => value.editable)
      )
    def descriptionValue: Option[ResourceDescription]
    def propertiesValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.PrivateDnsNamespacePropertiesChange.ReadOnly
    ]
    def description: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def properties: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.PrivateDnsNamespacePropertiesChange.ReadOnly
    ] = AwsError.unwrapOptionField("properties", propertiesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.PrivateDnsNamespaceChange
  ) extends io.github.vigoo.zioaws.servicediscovery.model.PrivateDnsNamespaceChange.ReadOnly {
    override def descriptionValue: Option[ResourceDescription] =
      scala.Option(impl.description()).map(value => value: ResourceDescription)
    override def propertiesValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.PrivateDnsNamespacePropertiesChange.ReadOnly
    ] = scala
      .Option(impl.properties())
      .map(value =>
        io.github.vigoo.zioaws.servicediscovery.model.PrivateDnsNamespacePropertiesChange
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.PrivateDnsNamespaceChange
  ): io.github.vigoo.zioaws.servicediscovery.model.PrivateDnsNamespaceChange.ReadOnly =
    new Wrapper(impl)
}
