package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.ResourceDescription
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PublicDnsNamespaceChange(
    description: Option[ResourceDescription] = None,
    properties: Option[
      io.github.vigoo.zioaws.servicediscovery.model.PublicDnsNamespacePropertiesChange
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.PublicDnsNamespaceChange = {
    import PublicDnsNamespaceChange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.PublicDnsNamespaceChange
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(properties.map(value => value.buildAwsValue()))(
        _.properties
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.PublicDnsNamespaceChange.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.PublicDnsNamespaceChange
      .wrap(buildAwsValue())
}
object PublicDnsNamespaceChange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.PublicDnsNamespaceChange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.PublicDnsNamespaceChange =
      io.github.vigoo.zioaws.servicediscovery.model.PublicDnsNamespaceChange(
        descriptionValue.map(value => value),
        propertiesValue.map(value => value.editable)
      )
    def descriptionValue: Option[ResourceDescription]
    def propertiesValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.PublicDnsNamespacePropertiesChange.ReadOnly
    ]
    def description: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def properties: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.PublicDnsNamespacePropertiesChange.ReadOnly
    ] = AwsError.unwrapOptionField("properties", propertiesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.PublicDnsNamespaceChange
  ) extends io.github.vigoo.zioaws.servicediscovery.model.PublicDnsNamespaceChange.ReadOnly {
    override def descriptionValue: Option[ResourceDescription] =
      scala.Option(impl.description()).map(value => value: ResourceDescription)
    override def propertiesValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.PublicDnsNamespacePropertiesChange.ReadOnly
    ] = scala
      .Option(impl.properties())
      .map(value =>
        io.github.vigoo.zioaws.servicediscovery.model.PublicDnsNamespacePropertiesChange
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.PublicDnsNamespaceChange
  ): io.github.vigoo.zioaws.servicediscovery.model.PublicDnsNamespaceChange.ReadOnly =
    new Wrapper(impl)
}
