package io.github.vigoo.zioaws.servicediscovery.model
import scala.jdk.CollectionConverters.*
sealed trait RecordType {
  def unwrap: software.amazon.awssdk.services.servicediscovery.model.RecordType
}
object RecordType {
  def wrap(
      value: software.amazon.awssdk.services.servicediscovery.model.RecordType
  ): io.github.vigoo.zioaws.servicediscovery.model.RecordType = value match {
    case software.amazon.awssdk.services.servicediscovery.model.RecordType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicediscovery.model.RecordType.SRV =>
      val r = SRV
      r
    case software.amazon.awssdk.services.servicediscovery.model.RecordType.A =>
      val r = A
      r
    case software.amazon.awssdk.services.servicediscovery.model.RecordType.AAAA =>
      val r = AAAA
      r
    case software.amazon.awssdk.services.servicediscovery.model.RecordType.CNAME =>
      val r = CNAME
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.servicediscovery.model.RecordType {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.RecordType =
      software.amazon.awssdk.services.servicediscovery.model.RecordType.UNKNOWN_TO_SDK_VERSION
  }
  case object SRV
      extends io.github.vigoo.zioaws.servicediscovery.model.RecordType {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.RecordType =
      software.amazon.awssdk.services.servicediscovery.model.RecordType.SRV
  }
  case object A
      extends io.github.vigoo.zioaws.servicediscovery.model.RecordType {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.RecordType =
      software.amazon.awssdk.services.servicediscovery.model.RecordType.A
  }
  case object AAAA
      extends io.github.vigoo.zioaws.servicediscovery.model.RecordType {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.RecordType =
      software.amazon.awssdk.services.servicediscovery.model.RecordType.AAAA
  }
  case object CNAME
      extends io.github.vigoo.zioaws.servicediscovery.model.RecordType {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.RecordType =
      software.amazon.awssdk.services.servicediscovery.model.RecordType.CNAME
  }
}
