package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.{
  AttrValue,
  AttrKey,
  InstanceId,
  ResourceId
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RegisterInstanceRequest(
    serviceId: ResourceId,
    instanceId: InstanceId,
    creatorRequestId: Option[ResourceId] = None,
    attributes: Map[AttrKey, AttrValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.RegisterInstanceRequest = {
    import RegisterInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.RegisterInstanceRequest
      .builder()
      .serviceId(serviceId: java.lang.String)
      .instanceId(instanceId: java.lang.String)
      .optionallyWith(creatorRequestId.map(value => value: java.lang.String))(
        _.creatorRequestId
      )
      .attributes(
        attributes
          .map({ case (key, value) =>
            (key: java.lang.String) -> (value: java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.RegisterInstanceRequest.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.RegisterInstanceRequest
      .wrap(buildAwsValue())
}
object RegisterInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.RegisterInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.RegisterInstanceRequest =
      io.github.vigoo.zioaws.servicediscovery.model.RegisterInstanceRequest(
        serviceIdValue,
        instanceIdValue,
        creatorRequestIdValue.map(value => value),
        attributesValue
      )
    def serviceIdValue: ResourceId
    def instanceIdValue: InstanceId
    def creatorRequestIdValue: Option[ResourceId]
    def attributesValue: Map[AttrKey, AttrValue]
    def serviceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(serviceIdValue)
    def instanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceIdValue)
    def creatorRequestId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestIdValue)
    def attributes: ZIO[Any, Nothing, Map[AttrKey, AttrValue]] =
      ZIO.succeed(attributesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.RegisterInstanceRequest
  ) extends io.github.vigoo.zioaws.servicediscovery.model.RegisterInstanceRequest.ReadOnly {
    override def serviceIdValue: ResourceId = impl.serviceId(): ResourceId
    override def instanceIdValue: InstanceId = impl.instanceId(): InstanceId
    override def creatorRequestIdValue: Option[ResourceId] =
      scala.Option(impl.creatorRequestId()).map(value => value: ResourceId)
    override def attributesValue: Map[AttrKey, AttrValue] = impl
      .attributes()
      .asScala
      .map({ case (key, value) =>
        (key: AttrKey) -> (value: AttrValue)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.RegisterInstanceRequest
  ): io.github.vigoo.zioaws.servicediscovery.model.RegisterInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
