package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.RecordTTL
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SOA(ttl: RecordTTL) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.SOA = {
    import SOA.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.SOA
      .builder()
      .ttl(ttl: java.lang.Long)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.servicediscovery.model.SOA.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.SOA.wrap(buildAwsValue())
}
object SOA {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.SOA
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.servicediscovery.model.SOA =
      io.github.vigoo.zioaws.servicediscovery.model.SOA(ttlValue)
    def ttlValue: RecordTTL
    def ttl: ZIO[Any, Nothing, RecordTTL] = ZIO.succeed(ttlValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.SOA
  ) extends io.github.vigoo.zioaws.servicediscovery.model.SOA.ReadOnly {
    override def ttlValue: RecordTTL = impl.ttl(): RecordTTL
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.SOA
  ): io.github.vigoo.zioaws.servicediscovery.model.SOA.ReadOnly = new Wrapper(
    impl
  )
}
