package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.ZIO
import io.github.vigoo.zioaws.servicediscovery.model.primitives.{
  ResourceDescription,
  Timestamp,
  Arn,
  ResourceCount,
  ServiceName,
  ResourceId
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Service(
    id: Option[ResourceId] = None,
    arn: Option[Arn] = None,
    name: Option[ServiceName] = None,
    namespaceId: Option[ResourceId] = None,
    description: Option[ResourceDescription] = None,
    instanceCount: Option[ResourceCount] = None,
    dnsConfig: Option[io.github.vigoo.zioaws.servicediscovery.model.DnsConfig] =
      None,
    `type`: Option[io.github.vigoo.zioaws.servicediscovery.model.ServiceType] =
      None,
    healthCheckConfig: Option[
      io.github.vigoo.zioaws.servicediscovery.model.HealthCheckConfig
    ] = None,
    healthCheckCustomConfig: Option[
      io.github.vigoo.zioaws.servicediscovery.model.HealthCheckCustomConfig
    ] = None,
    createDate: Option[Timestamp] = None,
    creatorRequestId: Option[ResourceId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.Service = {
    import Service.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.Service
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(namespaceId.map(value => value: java.lang.String))(
        _.namespaceId
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(instanceCount.map(value => value: Integer))(
        _.instanceCount
      )
      .optionallyWith(dnsConfig.map(value => value.buildAwsValue()))(
        _.dnsConfig
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(healthCheckConfig.map(value => value.buildAwsValue()))(
        _.healthCheckConfig
      )
      .optionallyWith(
        healthCheckCustomConfig.map(value => value.buildAwsValue())
      )(_.healthCheckCustomConfig)
      .optionallyWith(createDate.map(value => value: Instant))(_.createDate)
      .optionallyWith(creatorRequestId.map(value => value: java.lang.String))(
        _.creatorRequestId
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.Service.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.Service.wrap(buildAwsValue())
}
object Service {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.Service
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.servicediscovery.model.Service =
      io.github.vigoo.zioaws.servicediscovery.model.Service(
        idValue.map(value => value),
        arnValue.map(value => value),
        nameValue.map(value => value),
        namespaceIdValue.map(value => value),
        descriptionValue.map(value => value),
        instanceCountValue.map(value => value),
        dnsConfigValue.map(value => value.editable),
        typeValue.map(value => value),
        healthCheckConfigValue.map(value => value.editable),
        healthCheckCustomConfigValue.map(value => value.editable),
        createDateValue.map(value => value),
        creatorRequestIdValue.map(value => value)
      )
    def idValue: Option[ResourceId]
    def arnValue: Option[Arn]
    def nameValue: Option[ServiceName]
    def namespaceIdValue: Option[ResourceId]
    def descriptionValue: Option[ResourceDescription]
    def instanceCountValue: Option[ResourceCount]
    def dnsConfigValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.DnsConfig.ReadOnly
    ]
    def typeValue
        : Option[io.github.vigoo.zioaws.servicediscovery.model.ServiceType]
    def healthCheckConfigValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.HealthCheckConfig.ReadOnly
    ]
    def healthCheckCustomConfigValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.HealthCheckCustomConfig.ReadOnly
    ]
    def createDateValue: Option[Timestamp]
    def creatorRequestIdValue: Option[ResourceId]
    def id: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("id", idValue)
    def arn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("arn", arnValue)
    def name: ZIO[Any, AwsError, ServiceName] =
      AwsError.unwrapOptionField("name", nameValue)
    def namespaceId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("namespaceId", namespaceIdValue)
    def description: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def instanceCount: ZIO[Any, AwsError, ResourceCount] =
      AwsError.unwrapOptionField("instanceCount", instanceCountValue)
    def dnsConfig: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.DnsConfig.ReadOnly
    ] = AwsError.unwrapOptionField("dnsConfig", dnsConfigValue)
    def `type`: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.ServiceType
    ] = AwsError.unwrapOptionField("type", typeValue)
    def healthCheckConfig: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.HealthCheckConfig.ReadOnly
    ] = AwsError.unwrapOptionField("healthCheckConfig", healthCheckConfigValue)
    def healthCheckCustomConfig: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.HealthCheckCustomConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "healthCheckCustomConfig",
      healthCheckCustomConfigValue
    )
    def createDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createDate", createDateValue)
    def creatorRequestId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.Service
  ) extends io.github.vigoo.zioaws.servicediscovery.model.Service.ReadOnly {
    override def idValue: Option[ResourceId] =
      scala.Option(impl.id()).map(value => value: ResourceId)
    override def arnValue: Option[Arn] =
      scala.Option(impl.arn()).map(value => value: Arn)
    override def nameValue: Option[ServiceName] =
      scala.Option(impl.name()).map(value => value: ServiceName)
    override def namespaceIdValue: Option[ResourceId] =
      scala.Option(impl.namespaceId()).map(value => value: ResourceId)
    override def descriptionValue: Option[ResourceDescription] =
      scala.Option(impl.description()).map(value => value: ResourceDescription)
    override def instanceCountValue: Option[ResourceCount] =
      scala.Option(impl.instanceCount()).map(value => value: ResourceCount)
    override def dnsConfigValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.DnsConfig.ReadOnly
    ] = scala
      .Option(impl.dnsConfig())
      .map(value =>
        io.github.vigoo.zioaws.servicediscovery.model.DnsConfig.wrap(value)
      )
    override def typeValue
        : Option[io.github.vigoo.zioaws.servicediscovery.model.ServiceType] =
      scala
        .Option(impl.`type`())
        .map(value =>
          io.github.vigoo.zioaws.servicediscovery.model.ServiceType.wrap(value)
        )
    override def healthCheckConfigValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.HealthCheckConfig.ReadOnly
    ] = scala
      .Option(impl.healthCheckConfig())
      .map(value =>
        io.github.vigoo.zioaws.servicediscovery.model.HealthCheckConfig
          .wrap(value)
      )
    override def healthCheckCustomConfigValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.HealthCheckCustomConfig.ReadOnly
    ] = scala
      .Option(impl.healthCheckCustomConfig())
      .map(value =>
        io.github.vigoo.zioaws.servicediscovery.model.HealthCheckCustomConfig
          .wrap(value)
      )
    override def createDateValue: Option[Timestamp] =
      scala.Option(impl.createDate()).map(value => value: Timestamp)
    override def creatorRequestIdValue: Option[ResourceId] =
      scala.Option(impl.creatorRequestId()).map(value => value: ResourceId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.Service
  ): io.github.vigoo.zioaws.servicediscovery.model.Service.ReadOnly =
    new Wrapper(impl)
}
