package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.ResourceDescription
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ServiceChange(
    description: Option[ResourceDescription] = None,
    dnsConfig: Option[
      io.github.vigoo.zioaws.servicediscovery.model.DnsConfigChange
    ] = None,
    healthCheckConfig: Option[
      io.github.vigoo.zioaws.servicediscovery.model.HealthCheckConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.ServiceChange = {
    import ServiceChange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.ServiceChange
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(dnsConfig.map(value => value.buildAwsValue()))(
        _.dnsConfig
      )
      .optionallyWith(healthCheckConfig.map(value => value.buildAwsValue()))(
        _.healthCheckConfig
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.ServiceChange.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.ServiceChange
      .wrap(buildAwsValue())
}
object ServiceChange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.ServiceChange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.servicediscovery.model.ServiceChange =
      io.github.vigoo.zioaws.servicediscovery.model.ServiceChange(
        descriptionValue.map(value => value),
        dnsConfigValue.map(value => value.editable),
        healthCheckConfigValue.map(value => value.editable)
      )
    def descriptionValue: Option[ResourceDescription]
    def dnsConfigValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.DnsConfigChange.ReadOnly
    ]
    def healthCheckConfigValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.HealthCheckConfig.ReadOnly
    ]
    def description: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def dnsConfig: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.DnsConfigChange.ReadOnly
    ] = AwsError.unwrapOptionField("dnsConfig", dnsConfigValue)
    def healthCheckConfig: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.HealthCheckConfig.ReadOnly
    ] = AwsError.unwrapOptionField("healthCheckConfig", healthCheckConfigValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.ServiceChange
  ) extends io.github.vigoo.zioaws.servicediscovery.model.ServiceChange.ReadOnly {
    override def descriptionValue: Option[ResourceDescription] =
      scala.Option(impl.description()).map(value => value: ResourceDescription)
    override def dnsConfigValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.DnsConfigChange.ReadOnly
    ] = scala
      .Option(impl.dnsConfig())
      .map(value =>
        io.github.vigoo.zioaws.servicediscovery.model.DnsConfigChange
          .wrap(value)
      )
    override def healthCheckConfigValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.HealthCheckConfig.ReadOnly
    ] = scala
      .Option(impl.healthCheckConfig())
      .map(value =>
        io.github.vigoo.zioaws.servicediscovery.model.HealthCheckConfig
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.ServiceChange
  ): io.github.vigoo.zioaws.servicediscovery.model.ServiceChange.ReadOnly =
    new Wrapper(impl)
}
